#include <Adafruit_NeoPixel.h>  // Library for controlling WS2812B (NeoPixel) LEDs

#define LED_PIN    2            // Pin to which all 3 LEDs (D2) are connected (from documentation on arduino board)
#define NUM_LEDS   3            // Number of LEDs in the strip (we have 3)
#define MOTOR_IN1 9             //Pin for forward moving
#define MOTOR_IN2 10            //Pin for backward moving

Adafruit_NeoPixel leds(NUM_LEDS, LED_PIN, NEO_GRB + NEO_KHZ800);  //definition of the LED strip

void setup() {
  
    TCCR1B = TCCR1B & 0b11111000 | 0x01; // Increase the PWM frequency on D9 and D10 to ~31 kHz
  
    pinMode(MOTOR_IN1, OUTPUT); //Set motor pins as outputs
    pinMode(MOTOR_IN2, OUTPUT); //Set motor pins as outputs

    leds.begin();            //prepares the LED library
    leds.setBrightness(60);  //limits LED brightness (0..255)
    leds.show();             // initial frame to LEDs
}

void loop() {

    //Forward full speed for 1 second
    analogWrite(MOTOR_IN1, 255);      // Motor runs forward at full speed
    leds.setPixelColor(0, leds.Color(0, 255, 0));     // LED #0 turns green
    leds.show();      //Update LEDs
    delay(1000);      //delay 1000 milisecond or one second
    analogWrite(MOTOR_IN1, 0);    //turn off motor
    leds.setPixelColor(0, 0);     // LED #0 turn off
    leds.show();      //Update LEDs
    delay(500);     //delay 500 milisecond or 0,5 second

      
    // backward full speed for 1 second
    analogWrite(MOTOR_IN2, 255);      // Motor runs backward at full speed
    leds.setPixelColor(2, leds.Color(0, 255, 0));       // LED #3 turns green
    leds.show();      //Update LEDs
    delay(1000);      //delay 1000 milisecond or one second
    analogWrite(MOTOR_IN2, 0);      //turn off motor
    leds.setPixelColor(2, 0);     // LED #3 turn off
    leds.show();      //Update LEDs
    delay(500);     //delay 500 milisecond or 0,5 second

}
